ORQPTQ3 ; SLC/CLA/KER - Demographic Functions             ; 01/09/2003
 ;;3.0;ORDER ENTRY/RESULTS REPORTING;**159**;Dec 17, 1997
 ;
DEMOG(Y,DFN) ; RETURN PATIENT'S DEMOGRAPHIC INFO
 ;DEM: SSN^DOB^AGE^SEX^RACE^ETHNICITY^RELIGION^MARITAL STATUS
 ;INP: PRIMARY DUZ;NAME^ATTENDING DUZ;NAME^LOCATION^WARD^RMBED
 N ORPTDEMO,ATTDUZ,PRIMDUZ,ORI,ORR,ORE,ORD,ORO D DEM^VADPT
 S ORI=0 F  S ORI=$O(VADM(11,ORI)) Q:+ORI=0  S ORD=$P(VADM(11,ORI),"^",2) S:$L(ORD) ORE=$G(ORE)_", "_ORD
 F  Q:$E(ORE,1,2)'=", "  S ORE=$E(ORE,3,$L(ORE))
 S ORI=0 F  S ORI=$O(VADM(12,ORI)) Q:+ORI=0  S ORD=$P($G(VADM(12,ORI)),"^",2) S:$L(ORD) ORR=$G(ORR)_", "_ORD
 F  Q:$E(ORR,1,2)'=", "  S ORR=$E(ORR,3,$L(ORR))
 S ORO=$P(VADM(8),U,2) S:'$L(ORE)&('$L(ORR))&('$D(VADM(11)))&('$D(VADM(12))) ORE=ORO
 S ORPTDEMO=$P(VADM(2),U)_U_$P(VADM(3),U,2)_U_VADM(4)_U_$P(VADM(5),U,2)_U_ORR_U_ORE_U_$P(VADM(9),U,2)_U_$P(VADM(10),U,2)
 K VAINDT,VADM,VAERR S VA200=1
 D INP^VADPT
 S Y=ORPTDEMO_U_$P(VAIN(2),U)_";"_$P(VAIN(2),U,2)_U_$P(VAIN(11),U)_";"_$P(VAIN(11),U,2)_U_U_$P(VAIN(4),U,2)_U_VAIN(5)
 K VA200,VAIN,VAERR
 Q
WRB(Y,DFN) ;return patient's ward, room-bed: ward ien^ward name room-bed
 N WNAME,WIEN S WIEN="",Y=""
 S WNAME=$G(^DPT(DFN,.1)) I $L(WNAME) S WIEN=$O(^DIC(42,"B",WNAME,WIEN))
 I $L($G(WNAME)),$L($G(WIEN)) S Y=WIEN_U_WNAME_" "_$G(^DPT(DFN,.101))
 Q
NAME(ORY,DFN) ; return patient's name in mixed case
 I '$L($G(^DPT(DFN,0))) S ORY="Not found" Q
 S ORY=$$LOWER^VALM1($P(^DPT(DFN,0),U))
 Q
ADDR(Y,DFN) ; RETURN PATIENT'S ADDRESS & PHONE NUMBER
 D ADD^VADPT
 S Y=VAPA(1)_"^"_VAPA(2)_"^"_VAPA(3)_"^"_VAPA(4)_"^"_$P(VAPA(5),"^",2)_"^"_VAPA(6)_"^"_VAPA(8)
 K VAPA
 Q
ATTPRIM(ORY,DFN) ; return patient's attending physician and primary provider
 ;          format: ATTEND DUZ^ATTEND NAME;PRIMARY DUZ^PRIMARY NAME
 K VAINDT S VA200=1
 D INP^VADPT
 S ORY=$S($L($G(VAIN(11))):VAIN(11),1:"^not found") ;attending physician
 S ORY=ORY_";"_$S($L($G(VAIN(2))):VAIN(2),1:"^not found") ;primary provider
 K VA200,VAIN
 Q
WARD(Y,DFN) ; RETURN PATIENT'S WARD
 D INP^VADPT
 S Y=VAIN(4)
 K VAIN
 Q
RMBED(Y,DFN) ; RETURN PATIENT'S ROOM-BED
 D INP^VADPT
 S Y=VAIN(5)
 K VAIN
 Q
ATTEND(Y,DFN) ; RETURN PATIENT'S ATTENDING PHYSICIAN
 ;NOT YET IMPLEMENTED
 ;D INP^VADPT
 Q
SSN(Y,DFN) ; RETURN PATIENT'S SSN
 D DEM^VADPT
 S Y=VADM(2)
 K VADM
 Q
DOB(Y,DFN) ; RETURN PATIENT'S DATE OF BIRTH
 D DEM^VADPT
 S Y=VADM(3)
 K VADM
 Q
AGE(Y,DFN) ; RETURN PATIENT'S AGE
 D DEM^VADPT
 S Y=VADM(4)
 K VADM
 Q
SEX(Y,DFN) ; RETURN PATIENT'S SEX
 D DEM^VADPT
 S Y=VADM(5)
 K VADM
 Q
